#include "..\..\DLL\d_iNES.h"

namespace {
uint8_t reg[4];

void sync (void) {
	int prg = reg[3] <<3 | reg[1] &0x07;
	if (reg[3] &0x08)
		EMU->SetPRG_ROM32(0x8, prg >>1);
	else {
		EMU->SetPRG_ROM16(0x8, prg);
		EMU->SetPRG_ROM16(0xC, prg |7);
	}
	EMU->SetCHR_ROM4(0x0, reg[3] <<5 | reg[1] >>3 &0x1F);
	EMU->SetCHR_ROM4(0x4, reg[3] <<5 | reg[2] >>3 &0x1F);
	if (reg[3] &0x04)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

void MAPINT writeReg (int bank, int addr, int val) {
	reg[bank >>1 &3] = val;
	sync();
}

void MAPINT reset (RESET_TYPE resetType) {
	for (auto& c: reg) c = 0;
	sync();
	for (int bank = 0x8; bank <= 0xF; bank++) EMU->SetCPUWriteHandler(bank, writeReg);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	for (auto& c: reg) SAVELOAD_BYTE(stateMode, offset, data, c);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 598;
} // namespace

MapperInfo MapperInfo_598 = {
	&mapperNum,
	_T("New Star 21-in-1"),
	COMPAT_FULL,
	NULL,
	reset,
	NULL,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};
